/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.firefox;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriverException;
import org.openqa.selenium.firefox.FirefoxBinary;
import org.openqa.selenium.internal.Require;

class Executable {
    private final File binary;
    private String version;
    private FirefoxBinary.Channel channel;

    public Executable(File userSpecifiedBinaryPath) {
        Require.argument((String)"Path to the firefox binary", (Object)userSpecifiedBinaryPath).nonNull();
        this.binary = userSpecifiedBinaryPath;
    }

    public File getDirectory() {
        return this.binary.getAbsoluteFile().getParentFile();
    }

    public File getFile() {
        return this.binary;
    }

    public String getPath() {
        return this.binary.getAbsolutePath();
    }

    public String getVersion() {
        if (this.version == null) {
            this.loadApplicationIni();
        }
        return this.version;
    }

    public FirefoxBinary.Channel getChannel() {
        if (this.channel == null) {
            this.loadChannelPref();
        }
        return this.channel;
    }

    private void loadApplicationIni() {
        block9: {
            Path applicationIni = this.getResource("application.ini");
            if (Files.exists(applicationIni, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(applicationIni);){
                    this.version = reader.lines().map(String::trim).filter(line -> line.startsWith("Version=")).findFirst().map(line -> line.substring("Version=".length())).orElseThrow(() -> new WebDriverException("Cannot get version info for Firefox binary " + String.valueOf(this.binary)));
                    break block9;
                }
                catch (IOException e) {
                    throw new WebDriverException("Cannot get version info for Firefox binary " + String.valueOf(this.binary), (Throwable)e);
                }
            }
            this.version = "1000.0 unknown";
        }
    }

    private void loadChannelPref() {
        block9: {
            Path channelPrefs = this.getResource("defaults/pref/channel-prefs.js");
            if (Files.exists(channelPrefs, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(channelPrefs);){
                    this.channel = reader.lines().map(String::trim).filter(line -> line.startsWith("pref(\"app.update.channel\"")).findFirst().map(line -> FirefoxBinary.Channel.fromString(line.substring("pref(\"app.update.channel\", \"".length(), line.length() - "\");".length()))).orElseThrow(() -> new WebDriverException("Cannot get channel info for Firefox binary " + String.valueOf(this.binary)));
                    break block9;
                }
                catch (IOException e) {
                    throw new WebDriverException("Cannot get channel info for Firefox binary " + String.valueOf(this.binary), (Throwable)e);
                }
            }
            this.channel = FirefoxBinary.Channel.RELEASE;
        }
    }

    private Path getResource(String resourceName) {
        Path binaryLocation = this.binary.getAbsoluteFile().toPath();
        if (Platform.getCurrent().is(Platform.MAC)) {
            return binaryLocation.getParent().getParent().resolve("Resources").resolve(resourceName);
        }
        return binaryLocation.getParent().resolve(resourceName);
    }
}

