/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.devtools.v126.audits.model;

import java.util.Objects;
import java.util.Optional;
import org.openqa.selenium.devtools.v126.audits.model.AffectedRequest;
import org.openqa.selenium.devtools.v126.audits.model.GenericIssueErrorType;
import org.openqa.selenium.devtools.v126.dom.model.BackendNodeId;
import org.openqa.selenium.devtools.v126.page.model.FrameId;
import org.openqa.selenium.json.JsonInput;

public class GenericIssueDetails {
    private final GenericIssueErrorType errorType;
    private final Optional<FrameId> frameId;
    private final Optional<BackendNodeId> violatingNodeId;
    private final Optional<String> violatingNodeAttribute;
    private final Optional<AffectedRequest> request;

    public GenericIssueDetails(GenericIssueErrorType errorType, Optional<FrameId> frameId, Optional<BackendNodeId> violatingNodeId, Optional<String> violatingNodeAttribute, Optional<AffectedRequest> request) {
        this.errorType = Objects.requireNonNull(errorType, "errorType is required");
        this.frameId = frameId;
        this.violatingNodeId = violatingNodeId;
        this.violatingNodeAttribute = violatingNodeAttribute;
        this.request = request;
    }

    public GenericIssueErrorType getErrorType() {
        return this.errorType;
    }

    public Optional<FrameId> getFrameId() {
        return this.frameId;
    }

    public Optional<BackendNodeId> getViolatingNodeId() {
        return this.violatingNodeId;
    }

    public Optional<String> getViolatingNodeAttribute() {
        return this.violatingNodeAttribute;
    }

    public Optional<AffectedRequest> getRequest() {
        return this.request;
    }

    private static GenericIssueDetails fromJson(JsonInput input) {
        GenericIssueErrorType errorType = null;
        Optional<FrameId> frameId = Optional.empty();
        Optional<BackendNodeId> violatingNodeId = Optional.empty();
        Optional<String> violatingNodeAttribute = Optional.empty();
        Optional<AffectedRequest> request = Optional.empty();
        input.beginObject();
        block14: while (input.hasNext()) {
            switch (input.nextName()) {
                case "errorType": {
                    errorType = (GenericIssueErrorType)((Object)input.read(GenericIssueErrorType.class));
                    continue block14;
                }
                case "frameId": {
                    frameId = Optional.ofNullable((FrameId)input.read(FrameId.class));
                    continue block14;
                }
                case "violatingNodeId": {
                    violatingNodeId = Optional.ofNullable((BackendNodeId)input.read(BackendNodeId.class));
                    continue block14;
                }
                case "violatingNodeAttribute": {
                    violatingNodeAttribute = Optional.ofNullable(input.nextString());
                    continue block14;
                }
                case "request": {
                    request = Optional.ofNullable((AffectedRequest)input.read(AffectedRequest.class));
                    continue block14;
                }
            }
            input.skipValue();
        }
        input.endObject();
        return new GenericIssueDetails(errorType, frameId, violatingNodeId, violatingNodeAttribute, request);
    }
}

