/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.net.URI;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import org.openqa.selenium.Beta;
import org.openqa.selenium.UsernameAndPassword;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.bidi.BiDi;
import org.openqa.selenium.bidi.HasBiDi;
import org.openqa.selenium.bidi.network.AddInterceptParameters;
import org.openqa.selenium.bidi.network.InterceptPhase;
import org.openqa.selenium.remote.Network;

@Beta
class RemoteNetwork
implements Network {
    private final BiDi biDi;
    private final org.openqa.selenium.bidi.module.Network network;
    private final Map<Long, AuthDetails> authHandlers = new ConcurrentHashMap<Long, AuthDetails>();
    private final AtomicLong callBackId = new AtomicLong(1L);

    public RemoteNetwork(WebDriver driver) {
        this.biDi = ((HasBiDi)driver).getBiDi();
        this.network = new org.openqa.selenium.bidi.module.Network(driver);
        this.interceptAuthTraffic();
    }

    private void interceptAuthTraffic() {
        this.network.addIntercept(new AddInterceptParameters(InterceptPhase.AUTH_REQUIRED));
        this.network.onAuthRequired(responseDetails -> {
            String requestId = responseDetails.getRequest().getRequestId();
            URI uri = URI.create(responseDetails.getRequest().getUrl());
            Optional<UsernameAndPassword> authCredentials = this.getAuthCredentials(uri);
            if (authCredentials.isPresent()) {
                this.network.continueWithAuth(requestId, authCredentials.get());
                return;
            }
            this.network.continueWithAuthNoCredentials(requestId);
        });
    }

    private Optional<UsernameAndPassword> getAuthCredentials(URI uri) {
        return this.authHandlers.values().stream().filter(authDetails -> authDetails.getFilter().test(uri)).map(AuthDetails::getUsernameAndPassword).findFirst();
    }

    @Override
    public long addAuthenticationHandler(UsernameAndPassword usernameAndPassword) {
        return this.addAuthenticationHandler(url -> true, usernameAndPassword);
    }

    @Override
    public long addAuthenticationHandler(Predicate<URI> filter, UsernameAndPassword usernameAndPassword) {
        long id = this.callBackId.incrementAndGet();
        this.authHandlers.put(id, new AuthDetails(filter, usernameAndPassword));
        return id;
    }

    @Override
    public void removeAuthenticationHandler(long id) {
        this.authHandlers.remove(id);
    }

    @Override
    public void clearAuthenticationHandlers() {
        this.authHandlers.clear();
    }

    private class AuthDetails {
        private final Predicate<URI> filter;
        private final UsernameAndPassword usernameAndPassword;

        public AuthDetails(Predicate<URI> filter, UsernameAndPassword usernameAndPassword) {
            this.filter = filter;
            this.usernameAndPassword = usernameAndPassword;
        }

        public Predicate<URI> getFilter() {
            return this.filter;
        }

        public UsernameAndPassword getUsernameAndPassword() {
            return this.usernameAndPassword;
        }
    }
}

