package org.openqa.selenium.devtools.v126.page.model;

import org.openqa.selenium.Beta;
import org.openqa.selenium.json.JsonInput;

/**
 * Fired when frame schedules a potential navigation.
 */
@java.lang.Deprecated()
public class FrameScheduledNavigation {

    private final org.openqa.selenium.devtools.v126.page.model.FrameId frameId;

    private final java.lang.Number delay;

    private final org.openqa.selenium.devtools.v126.page.model.ClientNavigationReason reason;

    private final java.lang.String url;

    public FrameScheduledNavigation(org.openqa.selenium.devtools.v126.page.model.FrameId frameId, java.lang.Number delay, org.openqa.selenium.devtools.v126.page.model.ClientNavigationReason reason, java.lang.String url) {
        this.frameId = java.util.Objects.requireNonNull(frameId, "frameId is required");
        this.delay = java.util.Objects.requireNonNull(delay, "delay is required");
        this.reason = java.util.Objects.requireNonNull(reason, "reason is required");
        this.url = java.util.Objects.requireNonNull(url, "url is required");
    }

    /**
     * Id of the frame that has scheduled a navigation.
     */
    public org.openqa.selenium.devtools.v126.page.model.FrameId getFrameId() {
        return frameId;
    }

    /**
     * Delay (in seconds) until the navigation is scheduled to begin. The navigation is not
     * guaranteed to start.
     */
    public java.lang.Number getDelay() {
        return delay;
    }

    /**
     * The reason for the navigation.
     */
    public org.openqa.selenium.devtools.v126.page.model.ClientNavigationReason getReason() {
        return reason;
    }

    /**
     * The destination URL for the scheduled navigation.
     */
    public java.lang.String getUrl() {
        return url;
    }

    private static FrameScheduledNavigation fromJson(JsonInput input) {
        org.openqa.selenium.devtools.v126.page.model.FrameId frameId = null;
        java.lang.Number delay = 0;
        org.openqa.selenium.devtools.v126.page.model.ClientNavigationReason reason = null;
        java.lang.String url = null;
        input.beginObject();
        while (input.hasNext()) {
            switch(input.nextName()) {
                case "frameId":
                    frameId = input.read(org.openqa.selenium.devtools.v126.page.model.FrameId.class);
                    break;
                case "delay":
                    delay = input.nextNumber();
                    break;
                case "reason":
                    reason = input.read(org.openqa.selenium.devtools.v126.page.model.ClientNavigationReason.class);
                    break;
                case "url":
                    url = input.nextString();
                    break;
                default:
                    input.skipValue();
                    break;
            }
        }
        input.endObject();
        return new FrameScheduledNavigation(frameId, delay, reason, url);
    }
}
