package org.openqa.selenium.devtools.v126.pwa;

import org.openqa.selenium.Beta;
import org.openqa.selenium.devtools.Command;
import org.openqa.selenium.devtools.Event;
import org.openqa.selenium.devtools.ConverterFunctions;
import java.util.Map;
import java.util.LinkedHashMap;
import org.openqa.selenium.json.JsonInput;

/**
 * This domain allows interacting with the browser to control PWAs.
 */
@Beta()
public class PWA {

    public static class GetOsAppStateResponse {

        private final java.lang.Integer badgeCount;

        private final java.util.List<org.openqa.selenium.devtools.v126.pwa.model.FileHandler> fileHandlers;

        public GetOsAppStateResponse(java.lang.Integer badgeCount, java.util.List<org.openqa.selenium.devtools.v126.pwa.model.FileHandler> fileHandlers) {
            this.badgeCount = java.util.Objects.requireNonNull(badgeCount, "badgeCount is required");
            this.fileHandlers = java.util.Objects.requireNonNull(fileHandlers, "fileHandlers is required");
        }

        public java.lang.Integer getBadgeCount() {
            return badgeCount;
        }

        public java.util.List<org.openqa.selenium.devtools.v126.pwa.model.FileHandler> getFileHandlers() {
            return fileHandlers;
        }

        private static GetOsAppStateResponse fromJson(JsonInput input) {
            java.lang.Integer badgeCount = 0;
            java.util.List<org.openqa.selenium.devtools.v126.pwa.model.FileHandler> fileHandlers = null;
            input.beginObject();
            while (input.hasNext()) {
                switch(input.nextName()) {
                    case "badgeCount":
                        badgeCount = input.nextNumber().intValue();
                        break;
                    case "fileHandlers":
                        fileHandlers = input.readArray(org.openqa.selenium.devtools.v126.pwa.model.FileHandler.class);
                        break;
                    default:
                        input.skipValue();
                        break;
                }
            }
            input.endObject();
            return new GetOsAppStateResponse(badgeCount, fileHandlers);
        }
    }

    /**
     * Returns the following OS state for the given manifest id.
     */
    public static Command<org.openqa.selenium.devtools.v126.pwa.PWA.GetOsAppStateResponse> getOsAppState(java.lang.String manifestId) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        return new Command<>("PWA.getOsAppState", Map.copyOf(params), input -> input.read(org.openqa.selenium.devtools.v126.pwa.PWA.GetOsAppStateResponse.class));
    }

    /**
     * Installs the given manifest identity, optionally using the given install_url
     * or IWA bundle location.
     *
     * TODO(crbug.com/337872319) Support IWA to meet the following specific
     * requirement.
     * IWA-specific install description: If the manifest_id is isolated-app://,
     * install_url_or_bundle_url is required, and can be either an http(s) URL or
     * file:// URL pointing to a signed web bundle (.swbn). The .swbn file's
     * signing key must correspond to manifest_id. If Chrome is not in IWA dev
     * mode, the installation will fail, regardless of the state of the allowlist.
     */
    public static Command<Void> install(java.lang.String manifestId, java.util.Optional<java.lang.String> installUrlOrBundleUrl) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        installUrlOrBundleUrl.ifPresent(p -> params.put("installUrlOrBundleUrl", p));
        return new Command<>("PWA.install", Map.copyOf(params));
    }

    /**
     * Uninstals the given manifest_id and closes any opened app windows.
     */
    public static Command<Void> uninstall(java.lang.String manifestId) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        return new Command<>("PWA.uninstall", Map.copyOf(params));
    }

    /**
     * Launches the installed web app, or an url in the same web app instead of the
     * default start url if it is provided. Returns a tab / web contents based
     * Target.TargetID which can be used to attach to via Target.attachToTarget or
     * similar APIs.
     */
    public static Command<org.openqa.selenium.devtools.v126.target.model.TargetID> launch(java.lang.String manifestId, java.util.Optional<java.lang.String> url) {
        java.util.Objects.requireNonNull(manifestId, "manifestId is required");
        LinkedHashMap<String, Object> params = new LinkedHashMap<>();
        params.put("manifestId", manifestId);
        url.ifPresent(p -> params.put("url", p));
        return new Command<>("PWA.launch", Map.copyOf(params), ConverterFunctions.map("targetId", org.openqa.selenium.devtools.v126.target.model.TargetID.class));
    }
}
